VERSION 5.00
Begin VB.Form fCairoDemo 
   Caption         =   "First simple cairo-Widgets and basic-concepts"
   ClientHeight    =   8055
   ClientLeft      =   60
   ClientTop       =   435
   ClientWidth     =   10800
   LinkTopic       =   "Form1"
   ScaleHeight     =   8055
   ScaleWidth      =   10800
   StartUpPosition =   3  'Windows-Standard
   Begin VB.ListBox List1 
      Height          =   960
      IntegralHeight  =   0   'False
      ItemData        =   "fCairoDemo.frx":0000
      Left            =   3180
      List            =   "fCairoDemo.frx":0007
      TabIndex        =   1
      Top             =   90
      Width           =   2775
   End
   Begin VB.OptionButton Option1 
      Caption         =   "Same thing here, another Dummy to check ""tabbing"""
      Height          =   945
      Left            =   6090
      TabIndex        =   2
      Top             =   90
      Width           =   1665
   End
   Begin VB.TextBox Text1 
      Height          =   945
      Left            =   150
      MultiLine       =   -1  'True
      TabIndex        =   0
      Text            =   "fCairoDemo.frx":001F
      Top             =   90
      Width           =   2925
   End
   Begin CairoTutorial.ucPanel ucPanel1 
      Height          =   2505
      Left            =   180
      TabIndex        =   3
      Top             =   1470
      Width           =   4305
      _ExtentX        =   7594
      _ExtentY        =   4419
   End
End
Attribute VB_Name = "fCairoDemo"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

'declared below is our first "simple and naive" Widget-Class (please look for "HeadSart-Comments" there)
Private lblHelloWorld As cwHelloWorld

'three of the "already more advanced" cwLabel-Widgets, just to demonstrate Control-nesting -
'which is BTW possible on *any* Widget without any restrictions - each cwImplementation
'can act as a Parent-Container for any other Widget - so, if you are: "in the mood",
'you can put a whole cwToolWindow-Widget as a Child into a cwLabel or into a cwCommandButton
'...just in case you are badly in need for stuff like that... ;-)
Private lblOuter As cwLabel, lblInner1 As cwLabel, lblInner2 As cwLabel

'and the usual Button-Demos of course (just to demonstrate, that Events - as well as the Tabbing - work as usual)
'The Widgets Tab-Order (within their hosting ucPanel) is determined by their Add-Order (no TabIndex needed)
Private WithEvents cmdSimple1 As cwSimpleButton
Attribute cmdSimple1.VB_VarHelpID = -1
Private WithEvents cmdSimple2 As cwSimpleButton
Attribute cmdSimple2.VB_VarHelpID = -1
Private WithEvents cmdDefault As cwSimpleButton
Attribute cmdDefault.VB_VarHelpID = -1
Private WithEvents cmdCancel As cwSimpleButton
Attribute cmdCancel.VB_VarHelpID = -1


Private Sub Form_Load()
Dim UTF8Bytes() As Byte 'let's load some unicode-Content first, which is then placed in the lblHelloWorld.Caption
  Open App.Path & "\Hello World UTF8.txt" For Binary Access Read As 1
    ReDim UTF8Bytes(0 To LOF(1) - 1)
    Get 1, , UTF8Bytes
  Close 1
  
  'The following "Control-creation-and-adding" lines seem a bit voluminous -
  'and in fact I could have shortened the amount of creation-code a bit,
  'by writing a small Helper-Sub for all these cwLabel-creations - but as
  'it stands there, it is more obvious for a first Demo, where some Widget
  '"came from" - and it may also serve as a "suggestion", since these code-
  'blocks somewhat resemble to the Control-describing-content, one can find
  'in our good old VB-Form-Files. And a Form-Designer, which allows to do all
  'that "more visually", is planned - for the moment you will need to live with
  'the following dynamic creation-lines, to build up your widget-hierarchies within
  'an ucPanel (which provides the root of "all the magic", please read the comments there)...
  
  'let's start with our simple cwHelloWorld-LabelWidget first (also used, to show the Unicode-render-capabilities)
  Set lblHelloWorld = New cwHelloWorld
    lblHelloWorld.Caption = Cairo.ToBSTR(UTF8Bytes, CP_UTF8) 'Cairo.ToBSTR can convert from e.g. UTF8 to VBs normal BSTRs
    lblHelloWorld.Widget.BackColor = vbYellow
    lblHelloWorld.Widget.BorderColor = vbRed
    lblHelloWorld.Widget.ForeColor = vbBlue
  ucPanel1.Widgets.Add lblHelloWorld, "lblHelloWorld", 20, 90, 175, 250
  
  'now a cwLabel (an outer one, acting as the parent for two other ones, which follow)
  Set lblOuter = New cwLabel
    lblOuter.Caption = "A cwLabel, acting as the Parent-Container for two other cwLabels" & vbCrLf & _
                       "(all Label-Widgets in this Demo have W.CanGetFocus at 'False', hence no Tabstop here)"
    lblOuter.Widget.BackColor = vbWhite
  ucPanel1.Widgets.Add lblOuter, "lblOuter", 215, 90, 445, 250
  
    Set lblInner1 = New cwLabel
      lblInner1.Caption = "I'm an inner (Child-)Label (with BorderWidth=0 and no BackColor) " & _
                         "...please drag me around, to test correct Clipping within the ClientArea of my outer ParentLabel!"
      lblInner1.Widget.BackColor = -1 'this ensures a fully transparent BackGround
      lblInner1.Widget.ForeColor = vbBlue
      lblInner1.BorderWidth = 0
      lblInner1.Alignment = vbCenter
      lblInner1.VAlign = True
      lblInner1.Widget.Moveable = True 'this can be set on any widget, to make it "RuntimeMoveable"
    lblOuter.Widgets.Add lblInner1, "lblInner1", 50, 50, 200, 80 '50 Pixel Offset from the Parent-Labels TopLeft
    
    Set lblInner2 = New cwLabel
      lblInner2.Caption = "I'm a sibling of the other Inner-Label (with a higher ZOrder, BorderWidth=2 and Alpha=0.5) " & _
                         "...please drag me around, to test correct Clipping within the ClientArea of my outer ParentLabel!"
      lblInner2.Widget.BackColor = vbGreen
      lblInner2.Widget.BorderColor = vbMagenta
      lblInner2.Widget.Alpha = 0.5
      lblInner2.BorderWidth = 2
      lblInner2.Alignment = vbCenter
      lblInner2.VAlign = True
      lblInner2.Widget.Moveable = True 'this can be set on any widget, to make it "RuntimeMoveable"
    lblOuter.Widgets.Add lblInner2, "lblInner2", 150, 150, 200, 80 '150 Pixel Offset from the Parent-Labels TopLeft
  
  
  'Ok, ok - now to the Buttons...
  Set cmdSimple1 = New cwSimpleButton
    cmdSimple1.Caption = "A simple Button with &Accelerator-Support"
  ucPanel1.Widgets.Add cmdSimple1, "cmdSimple1", 20, 370, 220, 24


  'And our second Button will get an Image-Icon...
  '...to ensure reusable Image-Resources, we already learned in Cairo-Tutorial-Demo #15,
  'how to preload them into the global Cairo.Imagelist under a given Key
  Cairo.ImageList.AddIconFromResourceFile "ButtonIcon1", "shell32.dll", 167, 48, 48
  
  Set cmdSimple2 = New cwSimpleButton
    cmdSimple2.Caption = "Another &Button, containing an Image"
    'and to reuse such an ImageResource in a Widget, we don't have to define a dedicated Property
    'in our Implementations - we just reuse something, which is already existent on 'W' (or .Widget)
    cmdSimple2.Widget.ImageKey = "ButtonIcon1" '<- just pass the appropriate ImageKey as Text
    'and although our Iconresource was loaded and stored as 48x48, we can define our desired
    '*Render*-size on our Widget differently (as needed - since the downscale-quality is pretty good)
    cmdSimple2.Widget.ImageSize = 18
    cmdSimple2.Widget.BackColor = &H303030
'    cmdSimple2.Widget.BorderColor = vbGreen
    cmdSimple2.Widget.ForeColor = &H99EE&
'    cmdSimple2.Widget.FontName = "Arial"
  'that's it - what remains is the usual "Controls-Add" into our Parent-Container of choice
  ucPanel1.Widgets.Add cmdSimple2, "cmdSimple2", 20, 400, 220, 24
  
  'and two additional Buttons, to fully cover the possibilities which are inherent within these
  '(at the first look) simple Controls (which are not that complicated with regards to "plain drawing",
  ' but more with regards to all the different states and actions they are able to perform)
  'So, in our cwSimpleButton-Implementation we already tried to respect these states and behaviour -
  'but let's check the remaining stuff (the Handling and Visualizing of the Default and Cancel-States) now
  Set cmdDefault = New cwSimpleButton
    cmdDefault.Caption = "&Default"
    cmdDefault.Widget.Default = True
  ucPanel1.Widgets.Add cmdDefault, "cmdDefault", 540, 370, 120, 24
  
  Set cmdCancel = New cwSimpleButton
    cmdCancel.Caption = "&Cancel"
    cmdCancel.Widget.Cancel = True
  ucPanel1.Widgets.Add cmdCancel, "cmdCancel", 540, 400, 120, 24
  
  
  'XXXXXXXXXXXXXXXXXXXXXXXX We are not yet ready with this Demo, please read below ;-) xxxxxxxxxxxxxxxxxxxxxx
  'And finally (since we have a Vector-engine behind all that) - Check this out!!! (by removing the comment)
'  ucPanel1.WidgetRoot.Zoom = 1.666
  
  'the above line, (without the comment) can ensure Zooming on all the Widgets within
  'a given ucPanel (or better within cWidgetRoot, which the ucPanel only hosts) - that's
  'pretty comfortable, since you can develop (or just think about your Widgets Render-Coords)
  'in "developer-friendly Pixel-Space" (in either case, no matter what ZoomLevel is used,
  'the development can always be done in these wellknown Pixel-units).
  'Switching the Zoom-Property from its default = 1 to something other, is only a
  'thing at "render-time" - and as said, that works globally on all "Vector-Widgets"
  'currently placed on a Panel, without any more requirements on your side, to "move or resize
  'widgets separately". MouseCoords are properly translated and adapted by the WindowManager, so
  'that also in your MouseEvents everything behaves as before (always the same Pixelbased Coords come in).
  'So this mode can be useful for your users, but for you as a developer as well,
  'at least it helps me a lot, to get some coords properly fixed, when I sometimes take a look
  'at a current widget in Zoom-Mode=2 or higher - some mistakes with the Coords become more obvious this way.
End Sub

Private Sub Form_Resize()
  ucPanel1.Move 0, 0, ScaleWidth, ScaleHeight 'here we ensure, that our ucPanel covers the full Form-Area
End Sub

'below are the two Button-Events, which we can receive here "as usual",
'since the two cwButton Widget-Variables were declared "WithEvents"
Private Sub cmdSimple1_Click()
  MsgBox "Click-Event Button1"
End Sub

Private Sub cmdSimple2_Click()
  MsgBox "Click-Event Button2"
End Sub

'and here the Event-Handling of a cwSimpleButton in 'Default-Mode' (capturing the return-key)
'starting a new instance of this hosting Form here (can be used, to check
'that memory and handles are relased properly, when closing such "stacked up"
'Forms (by looking into the TaskManager).
Private Sub cmdDefault_Click()
Dim F As fCairoDemo
  Set F = New fCairoDemo
  F.Show
End Sub

Private Sub cmdCancel_Click() 'same thing for the Cancel-Mode (by pressing the Esc-Key)
  Unload Me
End Sub

